// BinarySearchTree.cpp: implementation of the BinarySearchTree class.
//
//////////////////////////////////////////////////////////////////////

#include "BinarySearchTree.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
template <class T>

BinarySearchTree<T> :: BinarySearchTree()
{
	root=new TreeNode<T>('*',0,0);;
	current=root;	
}

template <class T>

void BinarySearchTree<T> :: Delete_Tree(TreeNode<T>*& t)
{
	if (t)
	{
		Delete_Tree(t->left);
		Delete_Tree(t->right);
		delete(t);
	}
}

template <class T>

void BinarySearchTree<T> :: DeleteBinarySearchTree()
{
	Delete_Tree(root);	
	current=0;
	root=0;
}

template <class T>

BinarySearchTree<T> :: ~BinarySearchTree()
{
	Delete_Tree(root);
}

template <class T>

bool BinarySearchTree<T> :: Empty()
{
	return (root==0?true:false);
}

template <class T>

void BinarySearchTree<T> :: Insert(T item)
{
	Insert_Item(root,item);
}

template <class T>

void BinarySearchTree<T> :: Insert_Item(TreeNode<T> * &t,T item)
{	
	if ((item=='1')&&(current->right==NULL))
	{
		TreeNode<T> * newnode=new TreeNode<T>('*',NULL,NULL);
		current->right=newnode;
		current=newnode;
	}

	else if ((item=='0')&&(current->left==NULL))
	{
		TreeNode<T> * newnode=new TreeNode<T>('*',NULL,NULL);
		current->left=newnode;
		current=newnode;
	}

	else if ((item=='1')&&(current->right!=NULL))
	{
		current=current->right;
		
	}

	else if ((item=='0')&&(current->left!=NULL))
	{
		current=current->left;
		
	}

	else if ((item!='0')||(item!='1'))
	{
		current->data=item;
		current=t;
	}
}


template <class T>

void BinarySearchTree<T> :: Get(T item,ofstream &output)
{	
	Get_Item(root,item ,output);
}

template <class T>

void BinarySearchTree<T> :: Get_Item(TreeNode<T> * &t,T item ,ofstream &output)
{	
	if (item=='1')
	{
		current=current->right;		

		if (current->data!='*')
		{
			output<<current->data;
			current=t;			
		}
	}

	else if (item=='0')
	{
		current=current->left;		

		if (current->data!='*')
		{
			output<<current->data;
			current=t;						
		}
	}	
}

template <class T>

void BinarySearchTree<T> :: FindNode(TreeNode<T> * &parrent, const T& searchitem)
{
	current=root;
	parent=0;

	while(current)
	{
		if(current->data==searchitem)
			break;
		else
		{
			parent=current;

			if (searchitem<current->data)
				current=current->left;
			else
				current=current->right;
		}
	}
}

template <class T>

void BinarySearchTree<T> :: Delete(T& searchkey)
{
	deleteItem(root,searchkey);
}

template <class T>

void BinarySearchTree<T> :: delete_item(TreeNode<T>* &t, T& searchkey)
{
	if (t)
	{
		if (t->data==searchkey)
			deleteRootItem(t);

		else if (searchkey<t->data)
			deleteItem(t->left,searchkey);

		else
			deleteItem(t->right,searchkey);
	}
	else
		cout<<"NOT FOUND ";
}

template <class T>

void BinarySearchTree<T> :: Delete_Root_Item(TreeNode<T>* &root)
{ 
	TreeNode* holder;
	T replacement_info;

	if (root)
	{
		if ((root->left==NULL)&&(root->right==NULL))
		{
			delete(root);
			root=NULL;
		}

		else if ((root->left)==NULL)
		{
			holder=root;
			root=root->right;
			holder->right=NULL;
			delete(holder);
		}

		else if ((root->right)==NULL)
		{
			holder=root;
			root=root->left;
			holder->left=NULL;
			delete(holder);
		}

		else
		{
			processLeftMost(root->right,replacement_info);
			root->data=replacement_info;
		}
	}
}


template <class T>

void BinarySearchTree<T> :: InOrderTraverseRec(TreeNode<T>* &t)
{
	if (t)
	{
		InOrderTraverseRec(t->left);
		cout<<t->data<<"\t";
		InOrderTraverseRec(t->right);
	}
}

template <class T>

void BinarySearchTree<T> :: PreOrderTraverseRec(TreeNode<T>* &t)
{
	if (t)
	{
		cout<<t->data<<"\t";
		PreOrderTraverseRec(t->left);		
		PreOrderTraverseRec(t->right);
	}
}

template <class T>

void BinarySearchTree<T> :: PostOrderTraverseRec(TreeNode<T>* &t)
{
	if (t)
	{		
		PostOrderTraverseRec(t->left);		
		PostOrderTraverseRec(t->right);
		cout<<t->data<<"\t";
	}
}

template <class T>

// Prints the specified tree

void BinarySearchTree<T> :: Print_Tree(TreeNode<T>* &t, int level)				
{
	if (t)	
	{
		Print_Tree(t->right, level+1);									

		for (int i=1 ; i<=6*level ; i++)		// ths loop is used to indent the blanks 
			cout<<" ";							// so  that the tree is visible in the output

		cout<<t->data<<endl<<endl;
		Print_Tree(t->left, level+1);									
		
	}	
}

template <class T>		

// Calling function of the Print_Tree

void BinarySearchTree<T> :: Print()			
{
	Print_Tree(root,0);
}
